
#ifndef __ANSIPRSR_H
#define __ANSIPRSR_H
#define ANSI_BUFFER_SIZE 4000
#include <stdio.h>

class TANSIParser {
protected:
	virtual int ConWriteString(char* pszString, int cbString) = 0;
	virtual void ConClearScreen() = 0;
	virtual void ConClearEOScreen() = 0;
	virtual void ConClearBOScreen() = 0;
	virtual void ConClearLine() = 0;
	virtual void ConClearEOLine() = 0;
	virtual void ConClearBOLine() = 0;
	virtual void ConSetCursorPosition(int x, int y) = 0;
	virtual void ConMoveCursorPosition(int x, int y) = 0;
	virtual void ConSetExtendedMode(int iFunction, int bEnable) = 0;
	virtual int NetWriteString(char* pszString, int cbString) = 0;

	virtual char* GetTerminalId();

// Added by I.Ioannou 06/04/97
  char* TANSIParser::PrintBuffer(char* pszBuffer, char* pszBufferEnd);

/*~~	Added by Titus von Boxberg, 30/3/1997	*/
	virtual void InsertLine(int numlines) = 0;
	virtual void InsertCharacter(int numchar) = 0;
	virtual void DeleteCharacter(int numchar) = 0;
//~~~
///// Added by Brad Johnson 8/5/96
  virtual int ConWriteCtrlString(char* pszString) = 0;
  virtual void ConHighVideo() = 0;
  virtual void ConLowVideo() = 0;
  virtual void ConNormal() = 0;
  virtual void ConForground(unsigned char Attrib) = 0;
  virtual void ConBackground(unsigned char Attrib) = 0;
  virtual void ConBlink() = 0;
  virtual void ConBlinkOff() = 0; // Added by I.Ioannou 06 April 1997
  virtual void ConReverseOn() = 0; // Added by I.Ioannou 11 May 1997
  virtual void ConReverseOff() = 0; // Added by I.Ioannou 11 May 1997
  virtual void ConScrollDown( int iStartRow , int iEndRow, int bUp ) = 0;
  virtual void ConLineWrap( int bEnabled ) = 0;
  virtual void ConSetAttrib(unsigned char wAttr) = 0;
  virtual unsigned char ConGetAttrib() = 0;

  int ConSetAttribute(int TextAttrib);

	virtual int ConGetCursorX() = 0;
	virtual int ConGetCursorY() = 0;
	virtual int ConGetWidth() = 0;
	virtual int ConGetHeight() = 0;


  void SaveCurX(int iX);
  void SaveCurY(int iY);

  char * pcScrollData;
  long iScrollSize;
  long *piScrollBegin;

  int iSavedCurX;
  int iSavedCurY;
  unsigned char iSavedAttributes;
  int iScrollStart;
  int iScrollEnd;
  int iTermSet;
  int bInBinaryRx;
  int bInBinaryTx;
  int bInEchoTx;
  int bInEchoRx;
  int bGraphChar;
  FILE * dumpfile;
  // Added by I.Ioannou 06 April 1997
  FILE * printfile;
  char InPrintMode;
  int inGraphMode;
/////
  char szBuffer[ANSI_BUFFER_SIZE];
  char *pszTail;
  char *pszHead;

	char* ParseIAC(char* pszBuffer, char* pszBufferEnd);
	char* ParseEscapeANSI(char* pszBuffer, char* pszBufferEnd);
  char* TANSIParser::ParseANSIBuffer(char* pszBuffer, char* pszBufferEnd);
	char* ParseEscape(char* pszBuffer, char* pszBufferEnd);
//  char *pszTerms[];// = {"ANSI","DEC-VT100","DEC-VT52","UNKNOWN"};

public:
  TANSIParser(char * szDumpFileName, char * pcSD, long iSS, long * iSB);
  ~TANSIParser();

	char* ParseBuffer(char* pszBuffer, char* pszBufferEnd);

};
#include <stdlib.h>

#include <ctype.h>
#include <string.h>
#include "telnet.h"

#ifndef __COLORS
   #define __COLORS
   #define BLACK 0
   #define BLUE 1
   #define GREEN 2
   #define CYAN 3
   #define RED 4
   #define MAGENTA 5
   #define YELLOW 6
   #define WHITE 7
   #endif
#endif