///////////////////////////////////////////////////////////////////
//                                                               //
//                                                               //
//      Key translations - I.Ioannou (roryt@hol.gr)              //
//          Athens - Greece    December 18, 1996 02:56am         //
//          Reads a .cfg file and keeps the key definitions      //
//                for the WIN32 console telnet                   //
//                                                               //
///////////////////////////////////////////////////////////////////
//                                                               //
//                class KeyTranslator                            //
//                                                               //
//  Load          : loads or replaces the keymap                 //
//  TranslateKey  : returns a char * to the key def              //
//  AddKeyDef     : Changes or adds the key translation          //
//  DeleteKeyDef  : Deletes a key def from the list              //
///////////////////////////////////////////////////////////////////
//                                                               //
// File format :                                                 //
//                                                               //
//  Comments with a ; in column 1                                //
//  Empty Lines ignored                                          //
//  The words are separated by a space, a tab, or a plus ("+")   //
//                                                               //
//  First a [GLOBAL] section :                                   //
//   [GLOBAL]                                                    //
//   VK_F1         112                                           //
//   .                                                           //
//   .                                                           //
//   [END_GLOBAL]                                                //
//                                                               //
//   The GLOBAL section defines the names of the keys            //
//   and the virtual key code they have.                         //
//   If you repeat a name you'll overwrite the code.             //
//   You can name the keys anything you like                     //
//   The Virtual key nymber must be in Decimal                   //
//   After the number you can put anything : it is ignored       //
//   Here you must put ALL the keys you'll use in the            //
//   other sections.                                             //
//                                                               //
//  Then the emulations sections :                               //
//                                                               //
//   [SCO_ANSI]                                                  //
//                                                               //
//   VK_F1                    \027[M or                          //
//   VK_F1                    ^[[M   or                          //
//   VK_F1 SHIFT              ^[[W  etc                          //
//   .                                                           //
//   .                                                           //
//   [SCO_ANSI_END]                                              //
//                                                               //
//   There are three parts :                                     //
//      a) the key name                                          //
//      b) the shift state                                       //
//         here you put compination of the words :               //
//                                                               //
//                RIGHT_ALT                                      //
//                LEFT_ALT                                       //
//                RIGHT_CTRL                                     //
//                LEFT_CTRL                                      //
//                SHIFT                                          //
//                NUMLOCK                                        //
//                SCROLLLOCK                                     //
//                CAPSLOCK                                       //
//                ENHANCED                                       //
//      c) the assigned string :                                 //
//         you can use the ^ for esc (^[ = 0x1b)                 //
//                         \ and a three digit decimal number    //
//                         (\027)                                //
//         You can't use the NULL !!!                            //
//         Also (for the moment) you can't use spaces            //
//         in the string : everything after the 3rd word is      //
//           ignored - use unsderscore instead.                  //
//                                                               //
//   for  example :                                              //
//                                                               //
//         VK_F4  SHIFT+LEFT_ALT  \0274m^[[M = 0x1b 4 m 0x1b [ M //
//         VK_F1  RIGHT_CTRL      This_is_ctrl_f1                //
//                                                               //
// You may have as many sections as you like                     //
// If you repeat any section (even the GLOBAL) you'll overwrite  //
// the common parts.                                             //
//                                                               //
///////////////////////////////////////////////////////////////////


#ifndef __KEYTRANS_H
#define __KEYTRANS_H

#define TOKEN_DELIMITERS " +\t" // The word's delimiters

/////////////////////////////////////////////////////////
//     Class TkeyDef - Key Definitions class           //
//                   - keeped in an array container    //
/////////////////////////////////////////////////////////


class TKeyDef
{
  char *    szKeyDef;
  DWORD     vk_code;
  DWORD     dwState;

public:
  TKeyDef();
  TKeyDef(char * def, DWORD state, DWORD code);
  ~TKeyDef();
  char * GetszKey();
  DWORD  GetCodeKey();
  char * operator=(char * def);
  DWORD  operator=(DWORD code);
  int   operator==(TKeyDef & t);
};



/////////////////////////////////////////////////////////////
//                class KeyTranslator                      //
//  Load          : loads or replaces the keymap           //
//  TranslateKey  : returns a sz to the key def            //
//  AddKeyDef     : Changes or adds the key translation    //
//  DeleteKeyDef  : Deletes a key def from the list        //
/////////////////////////////////////////////////////////////


class KeyTranslator
{
  public:
    KeyTranslator();
    ~KeyTranslator() { DeleteAllDefs(); }
    int Load( char * filename,  char * szKeysetName);
            // If called more than once the new map replaces the old one.
            // load with a different KeysetName to change keysets
            // Return 0 on error
    char * TranslateKey(WORD wVirtualKeyCode, DWORD dwControlKeyState);
            // Returns a pointer to the string that should be printed.
            // Should return NULL if there is no translation for the key.
    int AddKeyDef( WORD wVirtualKeyCode, DWORD dwControlKeyState, char*lpzKeyDef);
            // Changes or adds the key translation associated with
            // wVirtualScanCode and dwControlKeyState.
            // Return 1 on success.
    int DeleteKeyDef( WORD wVirtualKeyCode, DWORD dwControlKeyState );

  private:
      void      DeleteAllDefs(void);
      int       AddGlobalDef(WORD wVirtualKeyCode, char*lpzKeyDef);
      DWORD     Fix_ControlKeyState(char *);
      char*     Fix_Tok(char *);
};


#endif // __KEYTRANS_H