#include "tnparser.h"


#define CON_TOP 0
#define CON_BOTTOM (ConsoleInfo.dwSize.Y - 1)
#define CON_LEFT 0
#define CON_RIGHT (ConsoleInfo.dwSize.X - 1)
#define CON_HEIGHT (CON_BOTTOM - CON_TOP)
#define CON_WIDTH (CON_RIGHT - CON_LEFT)
#define CON_LINES (CON_HEIGHT + 1)
#define CON_COLS (CON_WIDTH + 1)

#define CON_CUR_X (DWORD)(ConsoleInfo.dwCursorPosition.X - CON_LEFT)
#define CON_CUR_Y (DWORD)(ConsoleInfo.dwCursorPosition.Y - CON_TOP)


void ConScrollDown( int iStartRow , int iEndRow, int bUp ){
//
//   Erases over the iStartRow for up,
//   Moves the iEndRow for up,
//   Erases over the iStartRow for down,
//   Moves the iEndRow for down,
//
  int wAttributes = 7;
  CHAR_INFO ciChar;
  COORD dwDestOrg = {0,0};
  SMALL_RECT srScrollWindow;
  CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;

  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &ConsoleInfo);
  if ( iStartRow < 0) iStartRow = 0;
  if ( iEndRow < 0) iEndRow = CON_HEIGHT;
  if ( iStartRow > CON_HEIGHT) iStartRow = CON_HEIGHT;
  if ( iEndRow > CON_HEIGHT) iEndRow = CON_HEIGHT;

  ciChar.Char.AsciiChar = ' ';           // fill with spaces
  ciChar.Attributes = wAttributes;       // fill with current attrib

  srScrollWindow.Left =   CON_LEFT;
  srScrollWindow.Right =  CON_RIGHT;

  if (bUp){
    srScrollWindow.Top =    (SHORT) ((CON_TOP + iStartRow )+1 );
    srScrollWindow.Bottom = (SHORT) ((CON_TOP + iEndRow ) );
    dwDestOrg.Y = -1 + srScrollWindow.Top;             // shift the screen up one line
  }
  else {
    srScrollWindow.Top =    (SHORT) (CON_TOP + iStartRow );
    srScrollWindow.Bottom = (SHORT) (CON_TOP + iEndRow ) -1;
    dwDestOrg.Y =  1 + srScrollWindow.Top;             // shift the screen Down one line
  }

  ScrollConsoleScreenBuffer(GetStdHandle(STD_OUTPUT_HANDLE), &srScrollWindow,
    NULL, dwDestOrg, &ciChar);
}

int main(int ArgC, char* ArgV[])
{

  CONSOLE_SCREEN_BUFFER_INFO  ConsoleScreenBufferInfo;
  GetConsoleScreenBufferInfo(
    GetStdHandle(STD_OUTPUT_HANDLE),
    &ConsoleScreenBufferInfo
  );

  int Result = 0;
  char pszString[]="010203040506070809101112131415161718192021222324252627282930313233343536373839";

  for (int r = 0; r < 50; r++){
      WriteConsole(GetStdHandle(STD_OUTPUT_HANDLE), pszString, strlen(pszString) , &Result, 0);
  }
  ConScrollDown( 10 , 20, 1 );
  SetConsoleScreenBufferSize(
    GetStdHandle(STD_OUTPUT_HANDLE),	// handle of console screen buffer
    ConsoleScreenBufferInfo.dwSize 	// new size in character rows and cols.
   );
  SetConsoleWindowInfo(
    GetStdHandle(STD_OUTPUT_HANDLE),	// handle of console screen buffer
    TRUE,	// coordinate type flag
    &ConsoleScreenBufferInfo.srWindow 	// address of new window rectangle
  );
  SetConsoleTextAttribute(
    GetStdHandle(STD_OUTPUT_HANDLE),	// handle of console screen buffer
    ConsoleScreenBufferInfo.wAttributes 	// text and background colors
   );
  return 0;
}
