///////////////////////////////////////////////////////////////////////////////
//Brad Johnson Console Telnet a Win32 ANSI telnet client.
//Copyright (C) 1997  Brad Johnson
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//jbj@chrysalis.org
//brad.johnson@chrysalis.org
//
//Brad Johnson
//P.O. Box 933
//Crowley, TX 76036
//
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
// Module:		tncon.cpp
//
// Contents:	telnet console processing
//
// Product:		telnet
//
// Revisions: 5.April.1997 jbj@chrysalis.org
//            9.Dec.1996 jbj@chrysalis.org
//            Version 2.0
//
//            02.Apr.1995	igor.milavec@uni-lj.si
//					  Original code
//
///////////////////////////////////////////////////////////////////////////////
#include "tncon.h"
#include "keytrans.h"

#define TNNOCON 0
#define TNPROMPT 1
#define TNSCROLLBACK 2

int telProcessConsole(TelThreadParams* pParams)
{
   KeyTranslator * MyKeyTrans;
   MyKeyTrans = pParams->KeyTrans;
//   MyKeyTrans.Load( "keys.cfg",  "ANSI" );
   char * p;
	int i;
//  printf("telProcessConsole()\n");
	HANDLE hConsole = GetStdHandle(STD_INPUT_HANDLE);

	SetConsoleMode(hConsole, 0);

	const DWORD nHandle = 2;
	HANDLE hHandle[nHandle] = {hConsole, pParams->hExit};

	for (;;) {
		DWORD dwInput;
		switch (WaitForMultipleObjects(nHandle, hHandle, FALSE, INFINITE)) {
			case WAIT_OBJECT_0: {
				INPUT_RECORD InputRecord[11];
				if (!ReadConsoleInput(hConsole, &InputRecord[0], 10, &dwInput))
					return TNPROMPT;
				for (i = 0; i < dwInput; i++){
					switch (InputRecord[i].EventType) {
						case KEY_EVENT:{
							if (InputRecord[i].Event.KeyEvent.bKeyDown) {
								switch (InputRecord[i].Event.KeyEvent.uChar.AsciiChar){
								  case ']':
									 if (InputRecord[i].Event.KeyEvent.dwControlKeyState
										  & RIGHT_ALT_PRESSED ||
										  InputRecord[i].Event.KeyEvent.dwControlKeyState
										  & LEFT_ALT_PRESSED)
										return TNPROMPT;
								  case '[':
									 if (InputRecord[i].Event.KeyEvent.dwControlKeyState
										  & RIGHT_ALT_PRESSED ||
										  InputRecord[i].Event.KeyEvent.dwControlKeyState
										  & LEFT_ALT_PRESSED){
//                                   printf("scrollback key detected.........");
										     return TNSCROLLBACK;
                                }
								}
//
//	 John Ioannou (roryt@hol.gr)
//   Athens 31/03/97 00:25am GMT+2
//   fix for win95 CAPSLOCK bug
//   first check if the user has keys with capslock
//   and then wee filter it
//
  WORD  keyCode  = InputRecord[i].Event.KeyEvent.wVirtualKeyCode;
  DWORD keyState = InputRecord[i].Event.KeyEvent.dwControlKeyState;

  p = MyKeyTrans->TranslateKey(keyCode, keyState
                & ~NUMLOCK_ON & ~SCROLLLOCK_ON);
  if (p == NULL)
  {
    p = MyKeyTrans->TranslateKey(keyCode, keyState
                & ~NUMLOCK_ON & ~SCROLLLOCK_ON &~ENHANCED_KEY);
    if (p == NULL)
    {
      p = MyKeyTrans->TranslateKey(keyCode, keyState
                & ~NUMLOCK_ON & ~SCROLLLOCK_ON & ~CAPSLOCK_ON);
      if (p == NULL)
      {
        p = MyKeyTrans->TranslateKey(keyCode, keyState
                & ~NUMLOCK_ON & ~SCROLLLOCK_ON & ~CAPSLOCK_ON &~ENHANCED_KEY);
      }
    }
  }
  if (p == NULL) // if we don't have a translator
  {
    if (InputRecord[i].Event.KeyEvent.uChar.AsciiChar)
        send(pParams->Socket,
            &InputRecord[i].Event.KeyEvent.uChar.AsciiChar,1, 0);
  }
  else
  {
      send(pParams->Socket,p,strlen(p), 0);
  }
//
//
							}
						}
					}
				} // keep going until no more input
				break;
			}
			default:
				return TNNOCON;
		}
	}
}

WORD scrollkeys (){
   HANDLE hConsole = GetStdHandle(STD_INPUT_HANDLE);
   INPUT_RECORD InputRecord;
   BOOL done = FALSE;

  	while (!done) {
		DWORD dwInput;
		WaitForSingleObject( hConsole, INFINITE );
      if (!ReadConsoleInput(hConsole, &InputRecord, 1, &dwInput)){
         done = TRUE;
         continue;
         }
      if (InputRecord.EventType == KEY_EVENT &&
          InputRecord.Event.KeyEvent.bKeyDown ) {
         switch (InputRecord.Event.KeyEvent.wVirtualKeyCode){
           case VK_ESCAPE:
             return InputRecord.Event.KeyEvent.wVirtualKeyCode;
           case VK_UP:
             return InputRecord.Event.KeyEvent.wVirtualKeyCode;
           case VK_DOWN:
             return InputRecord.Event.KeyEvent.wVirtualKeyCode;
           case VK_NEXT:
             return InputRecord.Event.KeyEvent.wVirtualKeyCode;
           case VK_PRIOR:
             return InputRecord.Event.KeyEvent.wVirtualKeyCode;
           case VK_TAB:
             return InputRecord.Event.KeyEvent.wVirtualKeyCode;
           case VK_RIGHT:
             break;
           case VK_LEFT:
             break;
           case VK_DELETE:
             break;
           case VK_BACK:
             break;

           default:
             break;
         }
		}
	}
   return SC_ESC;
}
