//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: MSG_COPYRIGHT
//
// MessageText:
//
//  Console Telnet version 2.0b4, Copyright (C) 1997 <http://www.chrysalis.org/jbj>
//  Brad Johnson.  Console Telnet comes with ABSOLUTELY NO WARRANTY; for details
//  read LICENSE.TXT.  This is free software, and you are welcome to redistribute
//  it under certain conditions.
//  
//
#define MSG_COPYRIGHT                    0x40000001L

//
// MessageId: MSG_USAGE
//
// MessageText:
//
//  
//  Opens a TELNET connection to a computer operating a TELNET service
//  (sometimes called a daemon). TELNET defaults to ANSI color support.
//  
//  TELNET [params][host [port]]
//  
//    params
//      -dFILENAME.EXT  Dumps all incoming data to FILENAME.EXT
//    host              Specifies the host name or IP address of the remote
//                      host to connect to.
//    port              Specifies the service port on the host to open a
//                      connection. Default is telnet port 23.
//  
//
#define MSG_USAGE                        0x40000002L

//
// MessageId: MSG_HELP
//
// MessageText:
//
//  Commands may be abbreviated.  '*'=not implimented. Commands are:
//  
//  close           close current connection
//  display        *display operating parameters
//  emulate        *emulate a vt100 or 3270 terminal
//  mode           *try to enter line-by-line or character-at-a-time mode
//  open            connect to a site
//  quit            exit telnet
//  keys            changes keymap
//  send           *transmit special characters ('send ?' for more)
//  set            *set operating parameters ('set ?' for more)
//  status         *print status information
//  toggle         *toggle operating parameters ('toggle ?' for more)
//  z              *suspend telnet
//  ?               print help information
//
#define MSG_HELP                         0x40000003L

//
// MessageId: MSG_INVCMD
//
// MessageText:
//
//  
//  Invalid command. Type "?" for help.
//
#define MSG_INVCMD                       0x40000004L

//
// MessageId: MSG_ERROR
//
// MessageText:
//
//  %1 failed.
//
#define MSG_ERROR                        0xC0000005L

//
// MessageId: MSG_INFO
//
// MessageText:
//
//  %1
//
#define MSG_INFO                         0x40000006L

//
// MessageId: MSG_WARNING
//
// MessageText:
//
//  %1
//
#define MSG_WARNING                      0x80000007L

//
// MessageId: MSG_TRYING
//
// MessageText:
//
//  Trying... %0
//
#define MSG_TRYING                       0x40000008L

//
// MessageId: MSG_CONNECTED
//
// MessageText:
//
//  Connected to %1. Escape key is ALT-].
//
#define MSG_CONNECTED                    0x40000009L

//
// MessageId: MSG_TERMBYREM
//
// MessageText:
//
//  
//  Connection terminated.
//
#define MSG_TERMBYREM                    0x4000000AL

//
// MessageId: MSG_WSAEINTR
//
// MessageText:
//
//  WSAEINTR
//
#define MSG_WSAEINTR                     0xC0002714L

//
// MessageId: MSG_WSAEBADF
//
// MessageText:
//
//  WSAEBADF
//
#define MSG_WSAEBADF                     0xC0002719L

//
// MessageId: MSG_WSAEACCESS
//
// MessageText:
//
//  WSAEACCESS
//
#define MSG_WSAEACCESS                   0xC000271DL

//
// MessageId: MSG_WSAEDEFAULT
//
// MessageText:
//
//  WSAEDEFAULT
//
#define MSG_WSAEDEFAULT                  0xC000271EL

//
// MessageId: MSG_WSAEINVAL
//
// MessageText:
//
//  WSAEINVAL
//
#define MSG_WSAEINVAL                    0xC0002726L

//
// MessageId: MSG_WSAEMFILE
//
// MessageText:
//
//  WSAEMFILE
//
#define MSG_WSAEMFILE                    0xC0002728L

//
// MessageId: MSG_WSAEWOULDBLOCK
//
// MessageText:
//
//  WSAEWOULDBLOCK
//
#define MSG_WSAEWOULDBLOCK               0xC0002733L

//
// MessageId: MSG_WSAEINPROGRESS
//
// MessageText:
//
//  WSAEINPROGRESS
//
#define MSG_WSAEINPROGRESS               0xC0002734L

//
// MessageId: MSG_WSAEALREADY
//
// MessageText:
//
//  WSAEALREADY
//
#define MSG_WSAEALREADY                  0xC0002735L

//
// MessageId: MSG_WSAENOTSOCK
//
// MessageText:
//
//  WSAENOTSOCK
//
#define MSG_WSAENOTSOCK                  0xC0002736L

//
// MessageId: MSG_WSAEDESTADDRREQ
//
// MessageText:
//
//  WSAEDESTADDRREQ
//
#define MSG_WSAEDESTADDRREQ              0xC0002737L

//
// MessageId: MSG_WSAEMSGSIZE
//
// MessageText:
//
//  WSAEMSGSIZE
//
#define MSG_WSAEMSGSIZE                  0xC0002738L

//
// MessageId: MSG_WSAEPROTOTYPE
//
// MessageText:
//
//  WSAEPROTOTYPE
//
#define MSG_WSAEPROTOTYPE                0xC0002739L

//
// MessageId: MSG_WSAENOPROTOOPT
//
// MessageText:
//
//  WSAENOPROTOOPT
//
#define MSG_WSAENOPROTOOPT               0xC000273AL

//
// MessageId: MSG_WSAEPROTONOTSUPPORT
//
// MessageText:
//
//  WSAEPROTONOTSUPPORT
//
#define MSG_WSAEPROTONOTSUPPORT          0xC000273BL

//
// MessageId: MSG_WSAESOCKNOTSUPPORT
//
// MessageText:
//
//  WSAESOCKNOTSUPPORT
//
#define MSG_WSAESOCKNOTSUPPORT           0xC000273CL

//
// MessageId: MSG_WSAEOPNOTSUPP
//
// MessageText:
//
//  WSAEOPNOTSUPP
//
#define MSG_WSAEOPNOTSUPP                0xC000273DL

//
// MessageId: MSG_WSAEPFNOTSUPPORT
//
// MessageText:
//
//  WSAEPFNOTSUPPORT
//
#define MSG_WSAEPFNOTSUPPORT             0xC000273EL

//
// MessageId: MSG_WSAEAFNOTSUPPORT
//
// MessageText:
//
//  WSAEAFNOTSUPPORT
//
#define MSG_WSAEAFNOTSUPPORT             0xC000273FL

//
// MessageId: MSG_WSAEADDRINUSE
//
// MessageText:
//
//  Address is in use.
//
#define MSG_WSAEADDRINUSE                0xC0002740L

//
// MessageId: MSG_WSAEADDRNOTAVAIL
//
// MessageText:
//
//  WSAEADDRNOTAVAIL
//
#define MSG_WSAEADDRNOTAVAIL             0xC0002741L

//
// MessageId: MSG_WSAENETDOWN
//
// MessageText:
//
//  Network is down.
//
#define MSG_WSAENETDOWN                  0xC0002742L

//
// MessageId: MSG_WSAENETUNREACH
//
// MessageText:
//
//  Network is unreachable.
//
#define MSG_WSAENETUNREACH               0xC0002743L

//
// MessageId: MSG_WSAENETRESET
//
// MessageText:
//
//  WSAENETRESET
//
#define MSG_WSAENETRESET                 0xC0002744L

//
// MessageId: MSG_WSAECONNABORTED
//
// MessageText:
//
//  WSAECONNABORTED
//
#define MSG_WSAECONNABORTED              0xC0002745L

//
// MessageId: MSG_WSAECONNRESET
//
// MessageText:
//
//  WSAECONNRESET
//
#define MSG_WSAECONNRESET                0xC0002746L

//
// MessageId: MSG_WSAENOBUFS
//
// MessageText:
//
//  WSAENOBUFS
//
#define MSG_WSAENOBUFS                   0xC0002747L

//
// MessageId: MSG_WSAEISCONN
//
// MessageText:
//
//  WSAEISCONN
//
#define MSG_WSAEISCONN                   0xC0002748L

//
// MessageId: MSG_WSAENOTCONN
//
// MessageText:
//
//  WSAENOTCONN
//
#define MSG_WSAENOTCONN                  0xC0002749L

//
// MessageId: MSG_WSAESHUTDOWN
//
// MessageText:
//
//  WSAESHUTDOWN
//
#define MSG_WSAESHUTDOWN                 0xC000274AL

//
// MessageId: MSG_WSAETOOMANYREFS
//
// MessageText:
//
//  WSAETOOMANYREFS
//
#define MSG_WSAETOOMANYREFS              0xC000274BL

//
// MessageId: MSG_WSAETIMEDOUT
//
// MessageText:
//
//  The request has timed out.
//
#define MSG_WSAETIMEDOUT                 0xC000274CL

//
// MessageId: MSG_WSAECONNREFUSED
//
// MessageText:
//
//  Connection refused.
//
#define MSG_WSAECONNREFUSED              0xC000274DL

//
// MessageId: MSG_WSAELOOP
//
// MessageText:
//
//  WSAELOOP
//
#define MSG_WSAELOOP                     0xC000274EL

//
// MessageId: MSG_WSAENAMETOOLONG
//
// MessageText:
//
//  WSAENAMETOOLONG
//
#define MSG_WSAENAMETOOLONG              0xC000274FL

//
// MessageId: MSG_WSAEHOSTDOWN
//
// MessageText:
//
//  WSAEHOSTDOWN
//
#define MSG_WSAEHOSTDOWN                 0xC0002750L

//
// MessageId: MSG_WSAEHOSTUNREACH
//
// MessageText:
//
//  Host is unreachable.
//
#define MSG_WSAEHOSTUNREACH              0xC0002751L

//
// MessageId: MSG_WSAESYSNOTREADY
//
// MessageText:
//
//  WSAESYSNOTREADY
//
#define MSG_WSAESYSNOTREADY              0xC000276BL

//
// MessageId: MSG_WSAVERNOTSUPPORTED
//
// MessageText:
//
//  Version not supported.
//
#define MSG_WSAVERNOTSUPPORTED           0xC000276CL

//
// MessageId: MSG_WSANOTINITIALISED
//
// MessageText:
//
//  Not initialised.
//
#define MSG_WSANOTINITIALISED            0xC000276DL

//
// MessageId: MSG_WSAHOST_NOT_FOUND
//
// MessageText:
//
//  Host not found.
//
#define MSG_WSAHOST_NOT_FOUND            0xC0002AF9L

//
// MessageId: MSG_WSATRY_AGAIN
//
// MessageText:
//
//  Try again.
//
#define MSG_WSATRY_AGAIN                 0xC0002AFAL

//
// MessageId: MSG_WSANO_RECOVERY
//
// MessageText:
//
//  No recovery.
//
#define MSG_WSANO_RECOVERY               0xC0002AFBL

//
// MessageId: MSG_WSANO_DATA
//
// MessageText:
//
//  No data.
//
#define MSG_WSANO_DATA                   0xC0002AFCL

