#ifndef __TNPARSER_H
#define __TNPARSER_H

#include "ansiprsr.h"

class TTelnetParser: public TANSIParser {
	HANDLE hConsole;
	SOCKET Socket;
protected:

	virtual int ConWriteString(char* pszString, int cbString);
	virtual void ConClearScreen();
	virtual void ConClearEOScreen();
	virtual void ConClearBOScreen();
	virtual void ConClearLine();
	virtual void ConClearEOLine();
	virtual void ConClearBOLine();
	virtual void ConSetCursorPosition(int x, int y);
	virtual void ConMoveCursorPosition(int x, int y);
	virtual void ConSetExtendedMode(int iFunction, BOOL bEnable);
	virtual int NetWriteString(char* pszString, int cbString);
///// Added by Brad Johnson 8/5/96
   virtual void ConHighVideo();
   virtual void ConLowVideo();
   virtual void ConNormal();
   virtual void ConForground(unsigned char wAttrib);
   virtual void ConBackground(unsigned char wAttrib);
   virtual void ConBlink();
   virtual void ConBlinkOff();  // Added by I.Ioannou 06 April 1997
   virtual void ConReverseOn(); // Added by I.Ioannou 11 May 1997
   virtual void ConReverseOff(); // Added by I.Ioannou 11 May 1997
   virtual void ConSetAttrib(unsigned char wAttr);
   virtual unsigned char ConGetAttrib();
   virtual int ConWriteCtrlString(char* pszString);
   virtual void ConScrollDown( int iStartRow , int iEndRow, int bUp );
   virtual void ConLineWrap( int bEnabled );
   unsigned char wAttributes;
/////

/*	v Added by Titus von Boxberg 30/3/97	*/
   virtual void InsertLine(int numlines);
   virtual void InsertCharacter(int numchar);
   virtual void DeleteCharacter(int numchar);
//	^

// Added by I.Ioannou 11 May 1997
  char InReverseMode;
//
   virtual int ConGetCursorX();
   virtual int ConGetCursorY();
   virtual int ConGetWidth();
   virtual int ConGetHeight();
   int iNumOfLines;
   int iNumOfCols;
   int bLineWrapEnabled;
   char * pcScrollData;
   long iScrollSize;
   long *iScrollBegin;

public:
	TTelnetParser(HANDLE hConsole, SOCKET Socket, char * szDumpFileName,
   char * pcScrollData, long iScrollSize, long * iScrollBegin);
  ~TTelnetParser();
};

#endif